/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.h14199.message.DbException;
import org.h14199.store.fs.FileChannelInputStream;
import org.h14199.store.fs.FilePath;
import org.h14199.store.fs.FilePathDisk;
import org.h14199.store.fs.FileZip;

public class FilePathZip
extends FilePath {
    @Override
    public FilePathZip getPath(String string) {
        FilePathZip filePathZip = new FilePathZip();
        filePathZip.name = string;
        return filePathZip;
    }

    @Override
    public void createDirectory() {
    }

    @Override
    public boolean createFile() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public void delete() {
        throw DbException.getUnsupportedException("write");
    }

    @Override
    public boolean exists() {
        boolean bl;
        block9: {
            String string = this.getEntryName();
            if (string.isEmpty()) {
                return true;
            }
            ZipFile zipFile = this.openZipFile();
            try {
                boolean bl2 = bl = zipFile.getEntry(string) != null;
                if (zipFile == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            zipFile.close();
        }
        return bl;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public FilePath getParent() {
        int n = this.name.lastIndexOf(47);
        return n < 0 ? null : this.getPath(this.name.substring(0, n));
    }

    @Override
    public boolean isAbsolute() {
        String string = FilePathZip.translateFileName(this.name);
        return FilePath.get(string).isAbsolute();
    }

    @Override
    public FilePath unwrap() {
        return FilePath.get(this.name.substring(this.getScheme().length() + 1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirectory() {
        try {
            String string = this.getEntryName();
            if (string.isEmpty()) {
                return true;
            }
            try (ZipFile zipFile = this.openZipFile();){
                String string2;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                do {
                    if (!enumeration.hasMoreElements()) return false;
                    ZipEntry zipEntry = enumeration.nextElement();
                    string2 = zipEntry.getName();
                    if (!string2.equals(string)) continue;
                    boolean bl = zipEntry.isDirectory();
                    return bl;
                } while (!string2.startsWith(string) || string2.length() != string.length() + 1 || !string2.equals(string + "/"));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean setReadOnly() {
        return true;
    }

    @Override
    public long size() {
        long l;
        block8: {
            ZipFile zipFile = this.openZipFile();
            try {
                ZipEntry zipEntry = zipFile.getEntry(this.getEntryName());
                long l2 = l = zipEntry == null ? 0L : zipEntry.getSize();
                if (zipFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }
            zipFile.close();
        }
        return l;
    }

    public ArrayList<FilePath> newDirectoryStream() {
        Object object = this.name;
        ArrayList<FilePath> arrayList = new ArrayList<FilePath>();
        try {
            if (((String)object).indexOf(33) < 0) {
                object = (String)object + "!";
            }
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            try (ZipFile zipFile = this.openZipFile();){
                String string = this.getEntryName();
                String string2 = ((String)object).substring(0, ((String)object).length() - string.length());
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    int n;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string3 = zipEntry.getName();
                    if (!string3.startsWith(string) || string3.length() <= string.length() || (n = string3.indexOf(47, string.length())) >= 0 && n < string3.length() - 1) continue;
                    arrayList.add(this.getPath(string2 + string3));
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "listFiles " + (String)object);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return new FileChannelInputStream(this.open("r"), true);
    }

    @Override
    public FileChannel open(String string) throws IOException {
        ZipFile zipFile = this.openZipFile();
        ZipEntry zipEntry = zipFile.getEntry(this.getEntryName());
        if (zipEntry == null) {
            zipFile.close();
            throw new FileNotFoundException(this.name);
        }
        return new FileZip(zipFile, zipEntry);
    }

    @Override
    public OutputStream newOutputStream(boolean bl) throws IOException {
        throw new IOException("write");
    }

    @Override
    public void moveTo(FilePath filePath, boolean bl) {
        throw DbException.getUnsupportedException("write");
    }

    private static String translateFileName(String string) {
        int n;
        if (string.startsWith("zip:")) {
            string = string.substring("zip:".length());
        }
        if ((n = string.indexOf(33)) >= 0) {
            string = string.substring(0, n);
        }
        return FilePathDisk.expandUserHomeDirectory(string);
    }

    @Override
    public FilePath toRealPath() {
        return this;
    }

    private String getEntryName() {
        int n = this.name.indexOf(33);
        String string = n <= 0 ? "" : this.name.substring(n + 1);
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private ZipFile openZipFile() throws IOException {
        String string = FilePathZip.translateFileName(this.name);
        return new ZipFile(string);
    }

    @Override
    public FilePath createTempFile(String string, boolean bl) throws IOException {
        if (!bl) {
            throw new IOException("File system is read-only");
        }
        return new FilePathDisk().getPath(this.name).createTempFile(string, true);
    }

    @Override
    public String getScheme() {
        return "zip";
    }
}

